@extends('layouts.app')

@section('content')
<div class="container" style="margin-top: 40px;">
  <div class="row">
    <div class="col-sm-offset-4 col-sm-4 box-alignment">
      <div class="horizontal-container">
     
        <div class="horizontal-form-box">
          <div class="horizontal-info-container text-center">
           
<img src="{{ asset('images/logo/logo.png') }}" title="Kappsoft" class="logo-alignment">
            <p class="horizontal-heading">Reset your password</p>
            <p class="horizontal-subtitle">Your password needs to be at least 8 characters.</p>
          </div>
          <form class="horizontal-form" method="POST" action="{{ route('password.update') }}">
              @csrf
               <input type="hidden" name="token" value="{{ $token }}">
                <div class="o3-form-group">
              <label for="new_password">Email</label>
             <input id="email" type="email" class="form-control  o3-input-lg @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus readonly>

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
            </div>
            <div class="o3-form-group">
              <label for="new_password">New password</label>.
              <input type="password" class="o3-form-control o3-input-lg" id="new_password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
               @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
            </div>
            <div class="o3-form-group">
              <label for="confirm_password">Confirm new password</label>
              <input type="password" class="o3-form-control o3-input-lg" id="password-confirm"  name="password_confirmation">
            </div>
          <!--   <button class="o3-btn o3-btn-primary o3-btn-block">Set new password</button> -->
             <button type="submit" class="o3-btn o3-btn-primary o3-btn-block">
                                    {{ __('Reset Password') }}
                                </button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<style type="text/css">
    @import 'https://static.stayjapan.com/assets/dashboard/application-33c1a06b7784b53cd746d479718b6295c0fcefebb696e78dcee7c68efc92fada.css';


.horizontal-container {
  margin: 0 auto;
  width: 100%;
  
  @media(min-width: 768px) {
    width: 500px;
  }
  
  //
  // Progress bar
  //
  /* Create circle */
  @mixin drawCircle {
    background-color: white;
    border-radius: 50%; 
    border: 2px solid #ccc;
    color: #ccc;
    display: block;
    height: 20px;
    line-height: 18px;
    margin: 0 auto;
    text-align: center;
    width: 20px;
  }

  /* Create line */
  @mixin drawLine {
    background-color: #e5e5e5;
    content: '';
    height: 3px;
    left: -50%;
    transform: translateX(50%);
    position: absolute;
    top: 9px;
    width: 100%;
    z-index: -1;
  }

    /* Custom progress bar */
  .progress-bar-container {
    position: relative;

    .custom-progress-bar {
      counter-reset: step; /* Initial step: 0 */
      padding-left: 0;
    }

    .custom-progress-bar li {
      float: left;
      font-size: 12px;
      list-style: none;
      position: relative;
      text-align: center;
      text-transform: uppercase;
      width: 50%;

    
    }

    .custom-progress-line {
      height: 3px;
      position: absolute;
      content: '';
      top: 9px;
      left: 0;
      width: auto;
      background-color: red;
    }
  }
 
  
  .horizontal-form-box {
    background-color: #fff;
    border: 1px solid #e5e5e5;
    height: 466px;
    padding: 30px;
    
    .horizontal-info-container {   
      img {
        height: 75px;
        margin-bottom: 20px; 
      }

      .horizontal-heading {
        color: #000;
        font-size: 22px; 
        font-weight: bold; 
        text-transform: capitalize;
      }

      .horizontal-subtitle {
        letter-spacing: 1px;
        margin-bottom: 20px;
        text-align: left;
      }
    }
  
    .horizontal-form {
      label,
      button {
        text-transform: capitalize;
      }

      label {
        color: #000;
        font-weight: normal;
      }
    }
  }
}
.box-alignment{
    background-color: #ffdddd;
        padding: 55px 25px;

}
.logo-alignment{
        margin: 20px;
}
</style>

@endsection