<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::post('/add', [App\Http\Controllers\WorkController::class, 'add'])->name('add');

Route::get('/worklist', [App\Http\Controllers\WorkController::class, 'index'])->name('worklist.index');


Route::get('/workstory', [App\Http\Controllers\EmployeeController::class, 'index'])->name('workstory');

Route::get('/addworkpage', [App\Http\Controllers\EmployeeController::class, 'addworkpage'])->name('addworkpage');

Route::get('/permission', [App\Http\Controllers\AdminController::class, 'permission'])->name('permission');

Route::post('/adduserlist', [App\Http\Controllers\AdminController::class, 'adduserlist'])->name('adduserlist');

Route::get('/permissionedit\{id}', [App\Http\Controllers\AdminController::class, 'edit'])->name('permission.edit');

Route::post('/permissionupdate\{id}', [App\Http\Controllers\AdminController::class, 'update'])->name('permissionupdate');

Route::delete('/permissiondelete\{id}', [App\Http\Controllers\AdminController::class, 'destroy'])->name('permissiondelete');


